unit traduction;

interface

uses conversion, disque_vierge, explorateur, childwin, config , about, images, scan_disk;

var
    langue:integer;
    textes_general:array[0..149] of string;
    textes_conversion:array[0..49] of string;
    textes_nouvelle_disquette:array[0..29] of string;
    textes_explorateur:array[0..19] of string;
    textes_disquette:array[0..39] of string;
    textes_parametres:array[0..9] of string;
    textes_a_propos:array[0..9] of string;
    textes_images:array[0..9] of string;
    textes_scandisk:array[0..19] of string;

procedure change_langue_application; forward;
procedure charge_textes_general; forward;
procedure charge_textes_conversion; forward;
procedure charge_textes_nouvelle_disquette; forward;
procedure charge_textes_explorateur; forward;
procedure charge_textes_disquette; forward;
procedure charge_textes_parametres; forward;
procedure charge_textes_a_propos; forward;
procedure charge_textes_images; forward;
procedure charge_textes_scandisk; forward;
procedure traduction_textes_general; forward;
procedure traduction_textes_conversion; forward;
procedure traduction_textes_nouvelle_disquette; forward;
procedure traduction_textes_explorateur(fenetre:texplorer); forward;
procedure traduction_textes_disquette(fenetre:tmdichild); forward;
procedure traduction_textes_parametres; forward;
procedure traduction_textes_a_propos; forward;
procedure traduction_textes_images; forward;
procedure traduction_textes_scandisk; forward;

implementation

uses main;


//Initialisation des textes dans la langue choisie
procedure change_langue_application;
begin
    charge_textes_general;
    charge_textes_conversion;
    charge_textes_nouvelle_disquette;
    charge_textes_explorateur;
    charge_textes_disquette;
    charge_textes_parametres;
    charge_textes_a_propos;
    charge_textes_images;
    charge_textes_scandisk;
end;


//Charge les textes de la fentre principale
procedure charge_textes_general;
begin
    if langue=0 then
    begin
    //Menu fichier
        textes_general[0]:='&Fichier';
        textes_general[1]:='&Nouveau';
        textes_general[2]:='&Ouvrir';
        textes_general[3]:='&Sauvegarder';
        textes_general[4]:='&Fermer';
        textes_general[5]:='&Quitter';
    //Menu outils
        textes_general[10]:='Ou&tils';
        textes_general[11]:='Conversion image disque';
        textes_general[12]:='Contrle image disque';
        textes_general[13]:='Batch ZIP';
        textes_general[14]:='Recherche doublons';
        textes_general[15]:='Options';
    //Menu fentre
        textes_general[20]:='Fe&ntres';
        textes_general[21]:='&Cascade';
        textes_general[22]:='Mosaque &horizontale';
        textes_general[23]:='Mosaque &verticale';
        textes_general[24]:='&Tout rduire';
        textes_general[25]:='Tout r&organiser';
        textes_general[26]:='&Explorateur';
    //Menu aide
        textes_general[30]:='&Aide';
        textes_general[31]:='&A propos...';
    //Barre d'outils
        textes_general[40]:='Nouvelle image disque';
        textes_general[41]:='Ouvrir une image disque existante';
        textes_general[42]:='Sauvegarder les modifications';
        textes_general[43]:='Fermer la fentre active';
        textes_general[44]:='Crer un nouveau rpertoire';
        textes_general[45]:='Effacer le(s) fichier(s) slectionn(s)';
        textes_general[46]:='Convertir une image disque ST, MSA, STT ou DIM';
        textes_general[47]:='Contrler l''tat des clusters d''une image disque';
        textes_general[48]:='Compresser des fichiers unitairement';
        textes_general[49]:='Rechercher des fichiers en double';
        textes_general[50]:='Ouvrir une fentre explorateur de fichiers';
        textes_general[51]:='Rglage des options';
        textes_general[52]:='Cascade';
        textes_general[53]:='Mosaque horizontale';
        textes_general[54]:='Mosaque verticale';
    //Slecteur de fichiers
        textes_general[70]:='Image disque (*.msa,*.st,*.dim,*.stt,*.zip)|*.msa;*.st;*.dim;*.stt;*.zip';
        textes_general[71]:='Image disque (*.st)|*.st';
        textes_general[72]:='Image disque compresse (*.msa)|*.msa';
        textes_general[73]:='Image disque STEEM (*.stt)|*.stt';
        textes_general[74]:='Image disque FastCopy pro (*.dim)|*.dim';
        textes_general[75]:='Choisir une image disque';
        textes_general[76]:='Choisir une image disque destination';
        textes_general[77]:='Slectionner les fichiers  zipper';
        textes_general[78]:='Slectionner les fichiers  comparer';
        textes_general[79]:='Tous fichiers (*.*)|*.*';
        textes_general[80]:='Image disque zippe (*.zip)|*.zip';
    //Contrle tat des clusters
        textes_general[90]:='   - Clusters libres : ';
        textes_general[91]:='   - Clusters utiliss : ';
        textes_general[92]:='   - Clusters rservs : ';
        textes_general[93]:='   - Clusters mauvais : ';
        textes_general[94]:='   - Clusters systme : ';
    //Divers
        textes_general[100]:=' dja ouvert';
        textes_general[101]:='Voulez vous zipper ces ';
        textes_general[102]:=' fichiers ?';
        textes_general[103]:='Fichiers compresss : ';
        textes_general[104]:='Compression termine';
        textes_general[105]:='Calcul du CRC des fichiers : ';
        textes_general[106]:='Comparaison des fichiers en cours...';
        textes_general[107]:='Recherche de doublons termine';
        textes_general[108]:='Conversion d''image disque';
        textes_general[109]:='Explorateur de fichiers dja ouvert';
        textes_general[110]:='Image disque non valide : ';
        textes_general[111]:='Fonction du format STT non supporte : ';
        textes_general[112]:='Les infos du bootsecteur sont diffrentes de celles de l''image STT :';
        textes_general[113]:='Bootsecteur :';
        textes_general[114]:='Nombre de faces : ';
        textes_general[115]:='Nombre de secteurs :';
        textes_general[116]:='Nombre de pistes : ';
        textes_general[117]:='Utiliser les infos du bootsecteur ?';
        textes_general[118]:='Erreur';
        textes_general[119]:='Nom invalide : ';
        textes_general[120]:='Fichier original : ';
        textes_general[121]:='    --> doublon : ';
        textes_general[122]:='Espace insuffisant';
        textes_general[123]:='Remplacer ? ';
        textes_general[124]:='Voulez-vous chercher dans les fichiers zip ?';
        textes_general[125]:='Voulez-vous ajouter d''autres fichiers ?';
        textes_general[126]:='Paramtres incorrects';
        textes_general[127]:='Prsence ST, MSA, STT ou DIM dans fichier ZIP. Continuer?';
    end else
    begin
    //Menu fichier
        textes_general[0]:='&File';
        textes_general[1]:='&New';
        textes_general[2]:='&Open';
        textes_general[3]:='&Save';
        textes_general[4]:='&Close';
        textes_general[5]:='&Quit';
    //Menu outils
        textes_general[10]:='&Tools';
        textes_general[11]:='Convert a disk image';
        textes_general[12]:='Check a disk image';
        textes_general[13]:='Batch ZIP';
        textes_general[14]:='Duplicate search';
        textes_general[15]:='Options';
    //Menu fentre
        textes_general[20]:='Wi&ndows';
        textes_general[21]:='&Cascade';
        textes_general[22]:='Tile &horizontal';
        textes_general[23]:='Tile &vertical';
        textes_general[24]:='&Minimize all';
        textes_general[25]:='&Arrange all';
        textes_general[26]:='&Explorer';
    //Menu aide
        textes_general[30]:='&Help';
        textes_general[31]:='&About...';
    //Barre d'outils
        textes_general[40]:='New disk image';
        textes_general[41]:='Open an existing disk image';
        textes_general[42]:='Save changes';
        textes_general[43]:='Close active window';
        textes_general[44]:='Create a new directory';
        textes_general[45]:='Delete selected file(s)';
        textes_general[46]:='Convert a disk image ST, MSA, STT or DIM';
        textes_general[47]:='Check clusters of a disk image';
        textes_general[48]:='Compress files one by one';
        textes_general[49]:='Duplicate files search';
        textes_general[50]:='Open explorer window';
        textes_general[51]:='Settings';
        textes_general[52]:='Cascade';
        textes_general[53]:='Tile horizontal';
        textes_general[54]:='Tile vertical';
    //Slecteur de fichiers
        textes_general[70]:='Disk image (*.msa,*.st,*.dim,*.stt,*.zip)|*.msa;*.st;*.dim;*.stt;*.zip';
        textes_general[71]:='Disk image (*.st)|*.st';
        textes_general[72]:='Compressed disk image (*.msa)|*.msa';
        textes_general[73]:='STEEM disk image (*.stt)|*.stt';
        textes_general[74]:='FastCopy pro disk image (*.dim)|*.dim';
        textes_general[75]:='Choose a disk image';
        textes_general[76]:='Choose a destination disk image';
        textes_general[77]:='Select files to zip';
        textes_general[78]:='Select files to compare';
        textes_general[79]:='All files (*.*)|*.*';
        textes_general[80]:='Zipped disk image (*.zip)|*.zip';
    //Contrle tat des clusters
        textes_general[90]:='   - Free clusters : ';
        textes_general[91]:='   - Used clusters : ';
        textes_general[92]:='   - Reserved clusters : ';
        textes_general[93]:='   - Bad clusters : ';
        textes_general[94]:='   - System clusters : ';
    //Divers
        textes_general[100]:=' allready open';
        textes_general[101]:='Do you want to zip these ';
        textes_general[102]:=' files ?';
        textes_general[103]:='Compressed files : ';
        textes_general[104]:='Compression complete';
        textes_general[105]:='Files CRC calculation : ';
        textes_general[106]:='Files comparison in progress...';
        textes_general[107]:='Duplicate search complete';
        textes_general[108]:='Disk image conversion';
        textes_general[109]:='Explorer allready open';
        textes_general[110]:='Invalid disk image : ';
        textes_general[111]:='Unsupported STT format function : ';
        textes_general[112]:='Bootsector''s informations are different from STT informations :';
        textes_general[113]:='Bootsector :';
        textes_general[114]:='Number of sides : ';
        textes_general[115]:='Number of sectors :';
        textes_general[116]:='Number of tracks : ';
        textes_general[117]:='Use bootsector informations ?';
        textes_general[118]:='Error';
        textes_general[119]:='Invalid name : ';
        textes_general[120]:='Original file : ';
        textes_general[121]:='    --> duplicate : ';
        textes_general[122]:='Insufficient space';
        textes_general[123]:='Replace ? ';
        textes_general[124]:='Do you want to search in zip files ?';
        textes_general[125]:='Do you want to add some other files ?';
        textes_general[126]:='Incorrect parameters';
        textes_general[127]:='ST, MSA, STT or DIM in ZIP file. Continue?';
    end;
end;


//Charge les textes de la fentre "conversion"
procedure charge_textes_conversion;
begin
    if langue=0 then
    begin
    //Divers
        textes_conversion[0]:='Choisir une image disque source';
        textes_conversion[1]:='Image disque ou fichier Zip (*.msa,*.st,*.dim,*.stt,*.zip)|*.msa;*.st;*.dim;*.stt;*.zip';
        textes_conversion[2]:='Image disque (*.st)|*.st';
        textes_conversion[3]:='Image disque compresse (*.msa)|*.msa';
        textes_conversion[4]:='Image disque STEEM (*.stt)|*.stt';
        textes_conversion[5]:='Image disque FastCopy pro (*.dim)|*.dim';
        textes_conversion[6]:='Choisir une image disque destination';
        textes_conversion[7]:='Souhaitez vous craser ';
        textes_conversion[8]:='Fichier Zip (*.zip)|*.zip';
        textes_conversion[9]:='Nouveau_';
        textes_conversion[10]:='Termin';
        textes_conversion[11]:='Conversion choue : ';
        textes_conversion[12]:='Conversion effectue : ';
        textes_conversion[13]:='Conversion inutile : ';
        textes_conversion[14]:='Conversion annule : ';
    //Interface
        textes_conversion[30]:='Conversion';
        textes_conversion[31]:='FICHIERS SOURCE';
        textes_conversion[32]:='PARAMETRES DE CONVERSION';
        textes_conversion[33]:='COMPTE-RENDU';
        textes_conversion[34]:='Compresser (ZIP)';
        textes_conversion[35]:='Ecraser sans confirmation';
        textes_conversion[36]:='Nb de fichiers (MSA):';
        textes_conversion[39]:='Ajouter des fichiers  la liste';
        textes_conversion[40]:='Supprimer le fichier slectionn de la liste';
        textes_conversion[41]:='Ajouter la deuxime partie d''un MSA  reconstituer';
    end else
    begin
    //Divers
        textes_conversion[0]:='Choose a source disk image';
        textes_conversion[1]:='Disk image or Zip file (*.msa,*.st,*.dim,*.stt,*.zip)|*.msa;*.st;*.dim;*.stt;*.zip';
        textes_conversion[2]:='Disk image (*.st)|*.st';
        textes_conversion[3]:='Compressed disk image (*.msa)|*.msa';
        textes_conversion[4]:='STEEM disk image (*.stt)|*.stt';
        textes_conversion[5]:='FastCopy pro disk image (*.dim)|*.dim';
        textes_conversion[6]:='Choose a destination disk image';
        textes_conversion[7]:='Do you want to overwrite ';
        textes_conversion[8]:='Zip file (*.zip)|*.zip';
        textes_conversion[9]:='New_';
        textes_conversion[10]:='Finished';
        textes_conversion[11]:='Conversion failed : ';
        textes_conversion[12]:='Conversion done : ';
        textes_conversion[13]:='Conversion useless : ';
        textes_conversion[14]:='Conversion canceled : ';
    //Interface
        textes_conversion[30]:='Conversion';
        textes_conversion[31]:='SOURCE FILES';
        textes_conversion[32]:='CONVERSION PARAMETERS';
        textes_conversion[33]:='REPORT';
        textes_conversion[34]:='Compress (ZIP)';
        textes_conversion[35]:='Overwrite without asking';
        textes_conversion[36]:='Nb of files (MSA):';
        textes_conversion[39]:='Add files to list';
        textes_conversion[40]:='Delete selected file from list';
        textes_conversion[41]:='Add second part of a splitted MSA file';
    end;
end;



//Charge les textes de la fentre "nouvelle disquette"
procedure charge_textes_nouvelle_disquette;
begin
    if langue=0 then
    begin
        textes_nouvelle_disquette[0]:='Disquette vierge';
        textes_nouvelle_disquette[1]:='Nombre de faces :';
        textes_nouvelle_disquette[2]:='Nombre de secteurs :';
        textes_nouvelle_disquette[3]:='Nombre de pistes :';
        textes_nouvelle_disquette[4]:='Taille des secteurs (octets) :';
        textes_nouvelle_disquette[5]:='Nombre de secteurs par cluster :';
        textes_nouvelle_disquette[6]:='Nombre d''entres dans le rpertoire racine :';
        textes_nouvelle_disquette[7]:='Nombre de secteurs par FAT :';
        textes_nouvelle_disquette[8]:='Taille disquette vierge :';
        textes_nouvelle_disquette[9]:='Espace disponible :';
        textes_nouvelle_disquette[10]:=' octets';
        textes_nouvelle_disquette[11]:='Ouvrir la nouvelle disquette';
        textes_nouvelle_disquette[12]:='Crer';
        textes_nouvelle_disquette[13]:='vierge.st';
        textes_nouvelle_disquette[14]:='NOUVELLE IMAGE DISQUE';
        textes_nouvelle_disquette[15]:='Image disque (*.st)|*.st';
    end else
    begin
        textes_nouvelle_disquette[0]:='Blank disk';
        textes_nouvelle_disquette[1]:='Number of sides :';
        textes_nouvelle_disquette[2]:='Number of sectors :';
        textes_nouvelle_disquette[3]:='Number of tracks :';
        textes_nouvelle_disquette[4]:='Sectors size (bytes) :';
        textes_nouvelle_disquette[5]:='Number of sectors by cluster :';
        textes_nouvelle_disquette[6]:='Number of entries in root directory :';
        textes_nouvelle_disquette[7]:='Number of sectors by FAT :';
        textes_nouvelle_disquette[8]:='Blank disk size :';
        textes_nouvelle_disquette[9]:='Free space :';
        textes_nouvelle_disquette[10]:=' bytes';
        textes_nouvelle_disquette[11]:='Open the new disk';
        textes_nouvelle_disquette[12]:='Create';
        textes_nouvelle_disquette[13]:='blank.st';
        textes_nouvelle_disquette[14]:='NEW DISK IMAGE';
        textes_nouvelle_disquette[15]:='Disk image (*.st)|*.st';
    end;
end;


//Charge les textes de la fentre explorateur
procedure charge_textes_explorateur;
begin
    if langue=0 then
    begin
        textes_explorateur[0]:=' octets';
        textes_explorateur[1]:='Nom';
        textes_explorateur[2]:='Taille';
        textes_explorateur[3]:='Nombre de fichiers slectionns : ';
        textes_explorateur[4]:='Taille fichiers slectionns : ';
        textes_explorateur[5]:='Explorateur';
        textes_explorateur[6]:='Heure';
        textes_explorateur[7]:='Date';
        textes_explorateur[8]:='Voir';
        textes_explorateur[9]:='Format d''image inconnu';
    end else
    begin
        textes_explorateur[0]:=' bytes';
        textes_explorateur[1]:='Name';
        textes_explorateur[2]:='Size';
        textes_explorateur[3]:='Number of selected files : ';
        textes_explorateur[4]:='Size of selected files : ';
        textes_explorateur[5]:='Explorer';
        textes_explorateur[6]:='Time';
        textes_explorateur[7]:='Date';
        textes_explorateur[8]:='View';
        textes_explorateur[9]:='Unknown picture format';
    end;
end;


//Charge les textes de la fentre disquette
procedure charge_textes_disquette;
begin
    if langue=0 then
    begin
    //Divers
        textes_disquette[0]:=' octets';
        textes_disquette[1]:='L''image disque ';
        textes_disquette[2]:=' a t modifie.';
        textes_disquette[3]:='Voulez-vous l''enregistrer ?';
        textes_disquette[4]:='La sauvegarde ne peut tre effectue au format d''origine .';
        textes_disquette[5]:='Choisir une image disque destination';
        textes_disquette[6]:='Image disque (*.st)|*.st';
        textes_disquette[7]:='Image disque non valide : ';
        textes_disquette[8]:=' fichiers';
        textes_disquette[9]:='Creation de ce rpertoire impossible';
        textes_disquette[10]:='Entrer le nom du rpertoire';
        textes_disquette[11]:='Voulez-vous effacer le fichier temporaire du rpertoire de travail ?';
        textes_disquette[12]:='Format d''image inconnu';
        textes_disquette[13]:='Donnes FAT illisibles';
    //Interface
        textes_disquette[20]:='Nom';
        textes_disquette[21]:='Taille';
        textes_disquette[22]:='Attr.';
        textes_disquette[23]:='Heure';
        textes_disquette[24]:='Date';
        textes_disquette[25]:='Faces :';
        textes_disquette[26]:='Secteurs :';
        textes_disquette[27]:='Piste dbut :';
        textes_disquette[28]:='Piste fin :';
        textes_disquette[29]:='Taille :';
        textes_disquette[30]:='Libre :';
        textes_disquette[31]:='Slection :';
        textes_disquette[32]:='Taille slection :';
        textes_disquette[33]:='Voir';
        textes_disquette[34]:='Enregistrer';
        textes_disquette[35]:='Slectionner le rpertoire destination';
        textes_disquette[36]:='Supprimer';
    end else
    begin
        textes_disquette[0]:=' bytes';
        textes_disquette[1]:='The disk image ';
        textes_disquette[2]:=' has been modified.';
        textes_disquette[3]:='Do you want to save ?';
        textes_disquette[4]:='The disk image can not be saved in the original format .';
        textes_disquette[5]:='Choose a destination disk image';
        textes_disquette[6]:='Disk image (*.st)|*.st';
        textes_disquette[7]:='Invalid disk image : ';
        textes_disquette[8]:=' files';
        textes_disquette[9]:='Impossible to create this directory';
        textes_disquette[10]:='Enter the directory name';
        textes_disquette[11]:='Do you want to delete the temporary file from the work directory ?';
        textes_disquette[12]:='Unknown picture format';
        textes_disquette[13]:='Unreadable FAT datas';
    //Interface
        textes_disquette[20]:='Name';
        textes_disquette[21]:='Size';
        textes_disquette[22]:='Attr.';
        textes_disquette[23]:='Time';
        textes_disquette[24]:='Date';
        textes_disquette[25]:='Sides :';
        textes_disquette[26]:='Sectors :';
        textes_disquette[27]:='Start track :';
        textes_disquette[28]:='End track :';
        textes_disquette[29]:='Size :';
        textes_disquette[30]:='Free :';
        textes_disquette[31]:='Selection :';
        textes_disquette[32]:='Selection size :';
        textes_disquette[33]:='View';
        textes_disquette[34]:='Save';
        textes_disquette[35]:='Choose the destination directory';
        textes_disquette[36]:='Delete';
    end;
end;


//Charge les textes de la fentre des paramtres
procedure charge_textes_parametres;
begin
    if langue=0 then
    begin
        textes_parametres[0]:='Rpertoire de travail :';
        textes_parametres[1]:='Tous fichiers|*.*';
        textes_parametres[2]:='Langue :';
        textes_parametres[3]:='Parcourir';
        textes_parametres[4]:='Slectionner le rpertoire destination';
        textes_parametres[5]:='Format nom de destination : "                              .                     "';
        textes_parametres[6]:='Format nom fichier ZIP :       "                              .                     "';
    end else
    begin
        textes_parametres[0]:='Work directory :';
        textes_parametres[1]:='All files|*.*';
        textes_parametres[2]:='Language :';
        textes_parametres[3]:='Browse';
        textes_parametres[4]:='Choose the destination directory';
        textes_parametres[5]:='Destination name format   : "                              .                     "';
        textes_parametres[6]:='Zip filename format     :       "                              .                     "';
    end;
end;


//Charge les textes de la fentre "A Propos.."
procedure charge_textes_a_propos;
begin
    if langue=0 then
    begin
        textes_a_propos[0]:='Cr par Zorg';
        textes_a_propos[1]:='Site Web :';
        textes_a_propos[2]:='A propos';
    end else
    begin
        textes_a_propos[0]:='Created by Zorg';
        textes_a_propos[1]:='Web site :';
        textes_a_propos[2]:='About';
    end;
end;


//Charge les textes de la fentre de visualisation des images
procedure charge_textes_images;
begin
    if langue=0 then
    begin
        textes_images[0]:='Changement format image SPS';
    end else
    begin
        textes_images[0]:='Change SPS picture format';
    end;
end;


//Charge les textes de la fentre de visualisation des images
procedure charge_textes_scandisk;
begin
    if langue=0 then
    begin
        textes_scandisk[0]:='Lgende';
        textes_scandisk[1]:='Systme :';
        textes_scandisk[2]:='Endommag :';
        textes_scandisk[3]:='Utilis :';
        textes_scandisk[4]:='Rserv :';
        textes_scandisk[5]:='Libre :';
        textes_scandisk[6]:='Choix fichier';
    end else
    begin
        textes_scandisk[0]:='Legend';
        textes_scandisk[1]:='System :';
        textes_scandisk[2]:='Bad :';
        textes_scandisk[3]:='Used :';
        textes_scandisk[4]:='Reserved :';
        textes_scandisk[5]:='Free :';
        textes_scandisk[6]:='Select file';
    end;
end;


//Mise en place des textes de la fentre principale
procedure traduction_textes_general;
begin
    with msa_converter do
    begin
    //Menu fichier
        menu_general.Items[0].Caption:=textes_general[0];
        menu_general.Items[0].items[0].Caption:=textes_general[1];
        menu_general.Items[0].items[1].Caption:=textes_general[2];
        menu_general.Items[0].items[2].Caption:=textes_general[3];
        menu_general.Items[0].items[3].Caption:=textes_general[4];
        menu_general.Items[0].items[5].Caption:=textes_general[5];
    //Menu outils
        menu_general.Items[1].Caption:=textes_general[10];
        menu_general.Items[1].items[0].Caption:=textes_general[11];
        menu_general.Items[1].items[1].Caption:=textes_general[12];
        menu_general.Items[1].items[2].Caption:=textes_general[13];
        menu_general.Items[1].items[3].Caption:=textes_general[14];
        menu_general.Items[1].items[5].Caption:=textes_general[15];
    //Menu fentre
        menu_general.Items[2].Caption:=textes_general[20];
        menu_general.Items[2].items[0].Caption:=textes_general[21];
        menu_general.Items[2].items[1].Caption:=textes_general[22];
        menu_general.Items[2].items[2].Caption:=textes_general[23];
        menu_general.Items[2].items[3].Caption:=textes_general[24];
        menu_general.Items[2].items[4].Caption:=textes_general[25];
        menu_general.Items[2].items[6].Caption:=textes_general[26];
    //Menu aide
        menu_general.Items[3].Caption:=textes_general[30];
        menu_general.Items[3].items[0].Caption:=textes_general[31];
    //Liste d'actions
        filenew1.Hint:=textes_general[40];
        fileopen1.Hint:=textes_general[41];
        filesave1.Hint:=textes_general[42];
        fileclose1.Hint:=textes_general[43];
        newdir1.Hint:=textes_general[44];
        filedelete1.Hint:=textes_general[45];
        act_conversion.Hint:=textes_general[46];
        act_controle_image_disque.Hint:=textes_general[47];
        act_batch_zip.Hint:=textes_general[48];
        act_recherche_doublons.Hint:=textes_general[49];
        act_explorateur.Hint:=textes_general[50];
        act_options.Hint:=textes_general[51];
        windowcascade1.Hint:=textes_general[52];
        windowtilehorizontal1.Hint:=textes_general[53];
        windowtilevertical1.Hint:=textes_general[54];
    end;
end;


//Mise en place des textes de la fentre de conversion
procedure traduction_textes_conversion;
begin
    with convert do
    begin
    //Interface
        convert.Caption :=textes_conversion[30];
        source.Caption :=textes_conversion[31];
        parametres.Caption :=textes_conversion[32];
        group_compte_rendu.Caption :=textes_conversion[33];
        compresser.Caption :=textes_conversion[34];
        ecraser_sans_confirm.Caption :=textes_conversion[35];
        label_nombre_msa.Caption:=textes_conversion[36];
        cmd_ajout_source.Hint :=textes_conversion[39];
        cmd_suppression_source.Hint :=textes_conversion[40];
        cmd_ajouter_msa.Hint :=textes_conversion[41];
    end;
end;


//Mise en place des textes de la fentre nouvelle disquette
procedure traduction_textes_nouvelle_disquette;
begin
    with disquette_vierge do
    begin
    //Interface
        disquette_vierge.Caption :=textes_nouvelle_disquette[0];
        label_faces.Caption :=textes_nouvelle_disquette[1];
        label_secteurs.Caption :=textes_nouvelle_disquette[2];
        label_pistes.Caption :=textes_nouvelle_disquette[3];
        label_taille_secteurs.Caption :=textes_nouvelle_disquette[4];
        label_secteurs_par_cluster.Caption :=textes_nouvelle_disquette[5];
        label_entrees_rep_principal.Caption :=textes_nouvelle_disquette[6];
        label_secteurs_par_fat.Caption :=textes_nouvelle_disquette[7];
        label_taille_disquette.Caption :=textes_nouvelle_disquette[8];
        label_espace_disponible.Caption :=textes_nouvelle_disquette[9];
        ouvrir_disquette.Caption :=textes_nouvelle_disquette[11];
        cmd_disquette_vierge.Caption :=textes_nouvelle_disquette[12];
    end;
end;


//Mise en place des textes de la fentre explorateur
procedure traduction_textes_explorateur(fenetre:texplorer);
begin
    with fenetre do
    begin
        contenu_repertoire.Columns[0].Caption:=textes_explorateur[1];
        contenu_repertoire.Columns[1].Caption:=textes_explorateur[2];
        contenu_repertoire.Columns[2].Caption:=textes_explorateur[6];
        contenu_repertoire.Columns[3].Caption:=textes_explorateur[7];
        label_nb_fichiers_selectionnes.Caption :=textes_explorateur[3];
        label_taille_fichiers_selectionnes.Caption :=textes_explorateur[4];
        fenetre.Caption :=textes_explorateur[5];
        Popupmenu_fichiers.Items[0].Caption :=textes_explorateur[8];
    end;
end;


//Mise en place des textes de la fentre disquette
procedure traduction_textes_disquette(fenetre:tmdichild);
begin
    with fenetre do
    begin
    //Interface
        contenu_repertoire.Columns[0].Caption:=textes_disquette[20];
        contenu_repertoire.Columns[1].Caption:=textes_disquette[21];
        contenu_repertoire.Columns[2].Caption:=textes_disquette[22];
        contenu_repertoire.Columns[3].Caption:=textes_disquette[23];
        contenu_repertoire.Columns[4].Caption:=textes_disquette[24];
        label_faces.Caption :=textes_disquette[25];
        label_secteurs.Caption :=textes_disquette[26];
        label_piste_debut.Caption :=textes_disquette[27];
        label_piste_fin.Caption :=textes_disquette[28];
        label_taille.Caption :=textes_disquette[29];
        label_libre.Caption :=textes_disquette[30];
        label_nb_fichiers_selectionnes.Caption :=textes_disquette[31];
        label_taille_fichiers_selectionnes.Caption :=textes_disquette[32];
        Popupmenu_fichiers.Items[0].Caption :=textes_disquette[33];
        Popupmenu_fichiers.Items[1].Caption :=textes_disquette[34];
        Popupmenu_fichiers.Items[2].Caption :=textes_disquette[36];
        Popupmenu_repertoires.Items[0].Caption :=textes_disquette[36];
    end;
end;


//Mise en place des textes de la fentre paramtres
procedure traduction_textes_parametres;
begin
    with options do
    begin
        label_repertoire_travail.Caption:=textes_parametres[0];
        label_langue.Caption:=textes_parametres[2];
        cmd_choix_rep_travail.Caption:=textes_parametres[3];
        label_nom_dest.Caption:=textes_parametres[5];
        label_nom_zip.Caption:=textes_parametres[6];
    end;
end;


//Mise en place des textes de la fentre "A propos"
procedure traduction_textes_a_propos;
begin
    with aboutbox do
    begin
        copyright.caption:=textes_a_propos[0];
        site_internet.caption:=textes_a_propos[1];
        caption:=textes_a_propos[2];
    end;
end;


//Mise en place des textes de la fentre de visualisation des images
procedure traduction_textes_images;
begin
    with visu_images do
    begin
        Popupmenu_sps.Items[0].Caption :=textes_images[0];
    end;
end;


//Mise en place des textes de la fentre de scandisk
procedure traduction_textes_scandisk;
begin
    with scandisk do
    begin
        label_legende.Caption:=textes_scandisk[0];
        label_legende_systeme.Caption:=textes_scandisk[1];
        label_legende_mauvais.Caption:=textes_scandisk[2];
        label_legende_utilise.Caption:=textes_scandisk[3];
        label_legende_reserve.Caption:=textes_scandisk[4];
        label_legende_libre.Caption:=textes_scandisk[5];
        cmd_choix_fichier.Caption:=textes_scandisk[6];
    end;
end;

end.

